/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.DPEConfig;
import ibm.nways.analysis.dpManager.Admin.DPETopology;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.DpeMonitor;
import ibm.nways.analysis.dpManager.Admin.PanViewCanvas;
import ibm.nways.analysis.dpManager.DPEDirectory;
import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class NetworkDisplay
extends Panel {
    private DpAdminPanel adminPanel;
    private DpeMonitor dpeMon;
    private DPETopology dpeTop;
    private DPEConfig dpeConfig;
    private PanViewCanvas Panorama;
    private CardLayout cLayout;
    private Hashtable dpeStatsTable;
    private Vector assignedDPEs;
    private Vector unAssignedDPEs;
    private Vector assNodeStorage;
    private Vector unAssNodeStorage;
    private DPEDirectory dpeDirCopy;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String card1 = adminRB.getString("s_card1");
    private static final String card2 = adminRB.getString("s_card2");
    private static final String card3 = adminRB.getString("s_card3");

    public NetworkDisplay(DpAdminPanel dpAdminPanel, Applet applet) {
        this.adminPanel = dpAdminPanel;
        this.cLayout = new CardLayout();
        this.setLayout(this.cLayout);
        this.dpeTop = new DPETopology(this, applet);
        this.dpeMon = new DpeMonitor(this, applet);
        this.dpeConfig = new DPEConfig(this, applet);
        this.add(card1, this.dpeTop);
        this.add(card2, this.dpeMon);
        this.add(card3, this.dpeConfig);
    }

    public DpAdminPanel getDpAdminRef() {
        return this.adminPanel;
    }

    public DPETopology getDpeTopRef() {
        return this.dpeTop;
    }

    public DpeMonitor getDpeMonRef() {
        return this.dpeMon;
    }

    public DPEConfig getDpeCfg() {
        return this.dpeConfig;
    }

    public boolean hasMouseClicked() {
        this.Panorama = this.dpeTop.getCanvas();
        MouseEvent mouseEvent = this.Panorama.getMouseEvent();
        return mouseEvent.getID() == 500;
    }

    public void showDpeTop() {
        this.cLayout.show(this, card1);
    }

    public void showDpeMon(String string) {
        boolean bl = this.hasMouseClicked();
        if (bl) {
            this.dpeMon.eventHandler(string);
            this.dpeMon.setSavedIp(string);
            this.cLayout.show(this, card2);
        }
    }

    public void showDPEConfig(String string) {
        this.dpeConfig.setDpeName(string);
        try {
            this.dpeDirCopy = this.adminPanel.getAdminInterface().lockDPEConfig(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dpeConfig.setDpeRanges(string, this.dpeDirCopy);
        this.cLayout.show(this, card3);
    }

    public DPEDirectory getDpeDirCopy() {
        return this.dpeDirCopy;
    }

    public void updateDPEInformation() {
        try {
            this.dpeStatsTable = this.adminPanel.getAdminInterface().getDpeStats();
            this.assignedDPEs = this.adminPanel.getAdminInterface().getAssignedDPEs();
            this.unAssignedDPEs = this.adminPanel.getAdminInterface().getUnAssignedDPEs();
            return;
        }
        catch (Exception exception) {
            System.out.println("An error has occurred while grabbing info from the server");
            exception.printStackTrace();
            return;
        }
    }

    public Hashtable getDpeStatsTable() {
        return this.dpeStatsTable;
    }

    public Vector getAssignedDPEs() {
        return this.assignedDPEs;
    }

    public Vector getUnAssignedDPEs() {
        return this.unAssignedDPEs;
    }

    public Vector getAssNodeStorage() {
        return this.assNodeStorage;
    }

    public Vector getUnAssNodeStorage() {
        return this.unAssNodeStorage;
    }

    public void setAssNodeStorage(Vector vector) {
        this.assNodeStorage = vector;
    }

    public void setUnAssNodeStorage(Vector vector) {
        this.unAssNodeStorage = vector;
    }

    public String giveHostNameGetIp(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            System.out.println("Inet exception");
            exception.printStackTrace();
        }
        return string2;
    }

    public String giveIpGetHostName(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (Exception exception) {
            System.out.println("Inet exception");
            exception.printStackTrace();
        }
        return string2;
    }
}

